/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.manager;

import filenet.vw.apps.manager.VWWorkflowManagerPanel;
import filenet.vw.apps.manager.images.VWImageLoader;
import filenet.vw.apps.manager.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWLogger;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseLaunchableApplication;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWLoadingWindow;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.ImageIcon;

public class VWWorkflowManagerApplication
extends VWBaseLaunchableApplication
implements IVWSplashWindowListener {
    private VWWorkflowManagerPanel m_mainPanel = null;

    public static void main(String[] argv) {
        try {
            VWDebug.init(VWLogger.ERROR);
            VWCommandLineArgs args = new VWCommandLineArgs(argv);
            VWSessionInfo sessionInfo = new VWSessionInfo(null, null, args);
            if (!sessionInfo.verifyLogon(null)) {
                System.exit(1);
            }
            VWWorkflowManagerApplication pApp = new VWWorkflowManagerApplication();
            pApp.init(sessionInfo);
            VWHelp.init(pApp);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(VWSessionInfo sessionInfo) {
        try {
            super.init(sessionInfo);
            this.setFormattedWindowTitle(VWResource.s_applicationTitle);
            ImageIcon icon = VWImageLoader.createImageIcon("manager.gif");
            if (icon != null && icon.getImage() != null) {
                this.setIconImage(icon.getImage());
            }
            if (!this.updatePosition("pwm_location", "pwm_size")) {
                Dimension dim = VWStringUtils.stringToDimension(VWResource.s_mainWindowDim);
                if (dim == null) {
                    dim = new Dimension(700, 400);
                }
                this.updatePosition(dim.width, dim.height);
            }
            VWLoadingWindow loadingWindow = new VWLoadingWindow((Frame)this, VWResource.s_applicationTitle);
            this.show();
            if (loadingWindow != null) {
                loadingWindow.start(this, 250);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void startProcessing() {
        try {
            this.m_mainPanel = new VWWorkflowManagerPanel();
            this.m_mainPanel.init(this.m_sessionInfo);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void childWindowClosed() {
        if (this.m_mainPanel != null) {
            this.m_mainPanel.refresh();
        }
    }

    protected boolean destroy() {
        try {
            if (this.m_mainPanel != null) {
                this.m_mainPanel.destroy();
            }
            return super.destroy();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }
}

